//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

UiLineEditBase {
    id : uiLineEdit

    property real fontSizeFactor : 1.0

    property alias readOnly  : edit.readOnly
    property alias inputMask : edit.inputMask
    property alias validator : edit.validator

    property alias padding : edit.padding
    property alias leftPadding : edit.leftPadding
    property alias rightPadding : edit.rightPadding
    property alias topPadding : edit.topPadding
    property alias bottomPadding : edit.bottomPadding

    property alias font : edit.font
    property color color : UiColors.getColor(UiColors.DarkGrey80)
    property alias echoMode : edit.echoMode

    property int minimumWidth : 80

    implicitWidth : Math.max(minimumWidth, edit.implicitWidth)
    implicitHeight : edit.implicitHeight

    textInput : edit
    baselineOffset : edit.baselineOffset
    clip : true

    Text {
        id : placeHolder

        padding : uiLineEdit.padding
        topPadding : uiLineEdit.topPadding
        bottomPadding : uiLineEdit.bottomPadding
        leftPadding : uiLineEdit.leftPadding
        rightPadding: uiLineEdit.rightPadding
        visible : edit.text.length <= 0 && !readOnly
        color : uiLineEdit.enabled
                ? UiColors.getColor(UiColors.MediumGrey33)
                : UiColors.getColor(UiColors.DisabledLightGrey13)
        text : uiLineEdit.placeHolderText
        wrapMode : Text.NoWrap
        elide : Qt.ElideRight
        font : edit.font

        anchors.fill : parent
    }

    TextInput {
        id : edit

        readonly property bool overflow : implicitWidth > width

        anchors.fill : uiLineEdit
        leftPadding : 6
        rightPadding : 6
        topPadding : 4
        bottomPadding : 4
        color : {
            if (!uiLineEdit.enabled) {
                return UiColors.getColor(UiColors.MediumLightGrey27);
            } else if (uiLineEdit.readOnly) {
                return UiColors.getColor(UiColors.MediumGrey45);
            } else {
                return uiLineEdit.color;
            }
        }

        text : uiLineEdit.text

        activeFocusOnTab  : true
        selectByMouse     : true
        selectionColor    : UiColors.getColor(UiColors.SelectionGreen)
        selectedTextColor : UiColors.getColor(UiColors.White)

        font : UiFonts.getFont(UiFonts.Light, Math.round(14 * fontSizeFactor))
    }

    Rectangle {
        id : background

        anchors.fill : parent
        z : -1
    }

    UiTextContextMenu {
        textEditor             : edit
        onContextMenuRequested : edit.forceActiveFocus()
    }

    Rectangle {
        id : fadeout

        anchors {
            bottom : uiLineEdit.bottom
            top : uiLineEdit.top
            right : uiLineEdit.right
            margins : 1
        }
        width : Math.min(uiLineEdit.width - 1, 32)
        visible : !edit.activeFocus && edit.overflow
        z : 2

        gradient : Gradient {
            orientation : Gradient.Horizontal

            GradientStop {
                position : 0
                color : "#00FFFFFF"
            }
            GradientStop {
                position : 1
                color : "#FFFFFF"
            }
        }
    }

    UiBorder {
        borderWidth : 1
        anchors.fill : uiLineEdit
        z : 3
        style : UiBorder.Solid
        color : {
            if (!uiLineEdit.enabled) {
                return UiColors.getColor(UiColors.DisabledLightGrey13);
            } else if (uiLineEdit.readOnly) {
                return UiColors.getColor(UiColors.ControlGrey20);
            } else if (uiLineEdit.activeFocus) {
                return UiColors.getColor(UiColors.SelectionGreen);
            } else if (uiLineEdit.hovered) {
                return UiColors.getColor(UiColors.HoverGreen);
            }

            return UiColors.getColor(UiColors.ControlGrey20);
        }
    }
}
